# バッチ設計書 6-Storage Version GC Controller

## 概要

本ドキュメントは、StorageVersionリソースのガベージコレクションを行うStorage Version GC Controllerの設計を記述する。

### 本バッチの処理概要

Storage Version GC Controllerは、kube-apiserverのリース（Lease）とStorageVersionリソースを監視し、不要になったStorageVersionエントリおよびオブジェクトを検出・削除するコントローラーである。

**業務上の目的・背景**：Kubernetesクラスタでは、各kube-apiserverインスタンスがStorageVersionリソースにリソースのストレージバージョン情報を記録する。apiserverインスタンスが削除された（リースが期限切れ・削除された）場合、そのインスタンスに関連するStorageVersionエントリが古くなる（stale）。本コントローラーは、不要なストレージバージョン情報をクリーンアップし、StorageVersionリソースの正確性を維持する。

**バッチの実行タイミング**：Leaseリソースの削除イベント、およびStorageVersionリソースの作成・更新イベントをInformerで監視し、イベント駆動で実行される。

**主要な処理内容**：
1. kube-apiserverリース（kube-system Namespace）の削除イベント監視
2. リース削除時: 全StorageVersionから該当APIServerIDのエントリを除去
3. StorageVersion作成/更新時: 存在しないAPIServerIDのエントリを検出・除去
4. StorageVersion StatusのserverStorageVersionsフィールドの更新
5. 全エントリ除去済みStorageVersionオブジェクトの削除

**前後の処理との関連**：kube-apiserverがLeaseリソースを管理し、StorageVersionリソースを作成する。Storage Version Migratorがストレージバージョンのマイグレーションを実行する。

**影響範囲**：StorageVersionリソース（apiserverinternal/v1alpha1）、Leaseリソース（coordination/v1）。

## バッチ種別

ガベージコレクション型（staleエントリ自動削除）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（随時） |
| 実行時刻 | 常時稼働 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | Leaseリソース削除イベント、StorageVersionリソース作成/更新イベント |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| kube-controller-manager起動 | Storage Version GC Controllerはkube-controller-manager内で起動 |
| Informerキャッシュ同期完了 | LeaseとStorageVersionのInformerキャッシュが同期済みであること |
| API Server接続 | kube-apiserverと通信可能であること |

### 実行可否判定

Leaseおよび StorageVersionのInformerキャッシュ同期（cache.WaitForCacheSync）が完了した場合にワーカーを起動する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コントローラーは設定パラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Lease Informer | Kubernetes API (coordination/v1 Lease) | kube-apiserverリースの削除イベント監視 |
| StorageVersion Informer | Kubernetes API (apiserverinternal/v1alpha1 StorageVersion) | StorageVersionの作成/更新イベント監視 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| StorageVersion Status更新 | Kubernetes API (apiserverinternal/v1alpha1) | staleエントリ除去後のステータス更新 |
| StorageVersion削除 | Kubernetes API (apiserverinternal/v1alpha1) | 全エントリ除去済みオブジェクトの削除 |

### 出力ファイル仕様

ファイル出力はなし。

## 処理フロー

### 処理シーケンス

```
1. コントローラー初期化（NewStorageVersionGC）
   └─ Informer登録、leaseQueue/storageVersionQueue作成
2. Run起動
   └─ キャッシュ同期待ち、leaseWorker/storageVersionWorker起動
3. leaseWorker（リース削除処理）
   ├─ 削除されたリース名を取得
   ├─ リースがまだ存在するか確認（復活チェック）
   ├─ 全StorageVersion一覧取得
   └─ 該当APIServerIDのエントリを除去、ステータス更新
4. storageVersionWorker（StorageVersion同期処理）
   ├─ StorageVersionを取得
   ├─ serverStorageVersions内の各APIServerIDのリース存在確認
   └─ 存在しないAPIServerIDのエントリを除去、ステータス更新
```

### フローチャート

```mermaid
flowchart TD
    A[コントローラー起動] --> B[キャッシュ同期]
    B --> C[leaseWorker起動]
    B --> D[storageVersionWorker起動]
    C --> E[リース削除イベント]
    E --> F{リースが本当に削除済み?}
    F -->|Yes| G[全StorageVersionスキャン]
    F -->|No| H[スキップ]
    G --> I[該当APIServerIDエントリ除去]
    I --> J[ステータス更新]
    D --> K[StorageVersion作成/更新イベント]
    K --> L[APIServerIDのリース存在確認]
    L --> M{存在しないID?}
    M -->|Yes| N[エントリ除去・ステータス更新]
    M -->|No| O[スキップ]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| リース確認 | etcd (leases) | SELECT | kube-system内のリース存在確認 |
| StorageVersion一覧 | etcd (storageversions) | SELECT | 全StorageVersion取得 |
| StorageVersion Status更新 | etcd (storageversions) | UPDATE | staleエントリ除去 |
| StorageVersion削除 | etcd (storageversions) | DELETE | 全エントリ除去済みオブジェクト |

### テーブル別操作詳細

#### StorageVersion (apiserverinternal/v1alpha1)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | status.storageVersions | staleエントリ除去後のリスト | APIServerID一致分を除外 |
| DELETE | - | serverStorageVersionsが空 | 全エントリ除去済み |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Lease取得エラー | API Serverエラー | リキュー |
| - | StorageVersion一覧取得エラー | API Serverエラー | リキュー |
| - | StorageVersion更新失敗 | 競合等 | リキュー |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 無制限（レートリミッター制御） |
| リトライ間隔 | TypedRateLimitingQueue（指数バックオフ） |
| リトライ対象エラー | 全API Serverエラー |

### 障害時対応

リース削除イベントとStorageVersion同期は独立した2つのワーカーで処理される。一方のワーカーでエラーが発生しても他方には影響しない。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | StorageVersion単位 |
| コミットタイミング | 各StorageVersion操作APIコール時 |
| ロールバック条件 | 操作失敗時はリキュー |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | StorageVersion数（APIリソースタイプ数に相当） |
| 目標処理時間 | ワーカーループ間隔 = 1秒 |
| メモリ使用量上限 | Informerキャッシュサイズに依存 |

## 排他制御

- leaseQueueとstorageVersionQueueの2つの独立したworkqueue
- 各キーは同時に1ワーカーのみが処理
- 2ワーカー間のStorageVersion更新競合は許容（コメントに記載: "It's okay for the two workers to conflict on update"）

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | コントローラー起動時 | "Starting storage version garbage collector" |
| 終了ログ | コントローラー停止時 | "Shutting down storage version garbage collector" |
| エラーログ | エラー発生時 | "timed out waiting for caches to sync", リース/StorageVersion処理エラー |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| workqueue深さ（lease/storageversion） | メトリクス（Prometheusで監視） | クラスタ管理者 |

## 備考

- ソースコード: `pkg/controller/storageversiongc/gc_controller.go`
- leaseQueueキュー名: `storage_version_garbage_collector_leases`
- storageVersionQueueキュー名: `storage_version_garbage_collector_storageversions`
- Leaseは`metav1.NamespaceSystem`（kube-system）を対象
- 2ワーカー構成: leaseWorker（リース削除ハンドリング）+ storageVersionWorker（StorageVersion同期）
